<?php
/*
 * Bacula(R) - The Network Backup Solution
 * Baculum   - Bacula web interface
 *
 * Copyright (C) 2013-2021 Kern Sibbald
 *
 * The main author of Baculum is Marcin Haba.
 * The original author of Bacula is Kern Sibbald, with contributions
 * from many others, a complete list can be found in the file AUTHORS.
 *
 * You may use this file and others of this release according to the
 * license defined in the LICENSE file, which includes the Affero General
 * Public License, v3.0 ("AGPLv3") and some additional permissions and
 * terms pursuant to its AGPLv3 Section 7.
 *
 * This notice must be preserved when any source code is
 * conveyed and/or propagated.
 *
 * Bacula(R) is a registered trademark of Kern Sibbald.
 */

use Baculum\API\Modules\BaculumAPIServer;
use Baculum\Common\Modules\Errors\GenericError;

/**
 * Console messages.
 *
 * @author Marcin Haba <marcin.haba@bacula.pl>
 * @category API
 * @package Baculum API
 */
class Messages extends BaculumAPIServer {

	public function get() {
		$misc = $this->getModule('misc');
		$limit = $this->Request->contains('limit') ? intval($this->Request['limit']) : 0;

		$cmd = ['messages'];
		$result = $this->getModule('bconsole')->bconsoleCommand($this->director, $cmd, null, true);
		$output = $result->output;
		if ($result->exitcode == 0) {
			$output = $limit > 0 ? array_slice($output, -$limit) : $output;
		}
		$this->output = $output;
		$this->error = $result->exitcode > 0 ? GenericError::ERROR_WRONG_EXITCODE : GenericError::ERROR_NO_ERRORS;
	}
}
?>
