<?php
/*
 * Bacula(R) - The Network Backup Solution
 * Baculum   - Bacula web interface
 *
 * Copyright (C) 2013-2022 Kern Sibbald
 *
 * The main author of Baculum is Marcin Haba.
 * The original author of Bacula is Kern Sibbald, with contributions
 * from many others, a complete list can be found in the file AUTHORS.
 *
 * You may use this file and others of this release according to the
 * license defined in the LICENSE file, which includes the Affero General
 * Public License, v3.0 ("AGPLv3") and some additional permissions and
 * terms pursuant to its AGPLv3 Section 7.
 *
 * This notice must be preserved when any source code is
 * conveyed and/or propagated.
 *
 * Bacula(R) is a registered trademark of Kern Sibbald.
 */

namespace Baculum\Common\Modules\Errors;

/**
 * Database error class.
 *
 * @author Marcin Haba <marcin.haba@bacula.pl>
 * @category Errors
 * @package Baculum Common
 */
class DatabaseError extends GenericError {
	const ERROR_DB_CONNECTION_PROBLEM = 2;
	const ERROR_DATABASE_ACCESS_NOT_SUPPORTED = 3;
	
	const MSG_ERROR_DB_CONNECTION_PROBLEM = 'Problem with connection to database.';
	const MSG_ERROR_DATABASE_ACCESS_NOT_SUPPORTED = 'Database access is not supported by this API instance.';
}
