<?php
/*
 * Bacula(R) - The Network Backup Solution
 * Baculum   - Bacula web interface
 *
 * Copyright (C) 2013-2022 Kern Sibbald
 *
 * The main author of Baculum is Marcin Haba.
 * The original author of Bacula is Kern Sibbald, with contributions
 * from many others, a complete list can be found in the file AUTHORS.
 *
 * You may use this file and others of this release according to the
 * license defined in the LICENSE file, which includes the Affero General
 * Public License, v3.0 ("AGPLv3") and some additional permissions and
 * terms pursuant to its AGPLv3 Section 7.
 *
 * This notice must be preserved when any source code is
 * conveyed and/or propagated.
 *
 * Bacula(R) is a registered trademark of Kern Sibbald.
 */

namespace Baculum\Common\Modules\Errors;

/**
 * Generic plugin error class.
 *
 * @author Marcin Haba <marcin.haba@bacula.pl>
 * @category Errors
 * @package Baculum Common
 */
class PluginError extends GenericError {
	const ERROR_EXECUTING_PLUGIN_QUERY_COMMAND = 150;
	const ERROR_WRONG_PLUGIN_OPTION = 151;

	const MSG_ERROR_EXECUTING_PLUGIN_QUERY_COMMAND = 'Error executing plugin query command.';
	const MSG_ERROR_WRONG_PLUGIN_OPTION = 'Wrong plugin option.';
}
