<?php
/*
 * Bacula(R) - The Network Backup Solution
 * Baculum   - Bacula web interface
 *
 * Copyright (C) 2013-2024 Kern Sibbald
 *
 * The main author of Baculum is Marcin Haba.
 * The original author of Bacula is Kern Sibbald, with contributions
 * from many others, a complete list can be found in the file AUTHORS.
 *
 * You may use this file and others of this release according to the
 * license defined in the LICENSE file, which includes the Affero General
 * Public License, v3.0 ("AGPLv3") and some additional permissions and
 * terms pursuant to its AGPLv3 Section 7.
 *
 * This notice must be preserved when any source code is
 * conveyed and/or propagated.
 *
 * Bacula(R) is a registered trademark of Kern Sibbald.
 */

use Baculum\API\Modules\BaculumAPIServer;
use Baculum\API\Modules\StatusStorage;
use Baculum\Common\Modules\Errors\StorageError;

/**
 * Cancel all jobs executed by given storage.
 *
 * @author Marcin Haba <marcin.haba@bacula.pl>
 * @category API
 * @package Baculum API
 */
class StorageJobsCancel extends BaculumAPIServer {

	public function set($storageid, $params) {
		$storage = null;
		if ($storageid > 0) {
			$storage = $this->getModule('storage')->getStorageById($storageid);
		}
		$result = $this->getModule('bconsole')->bconsoleCommand(
			$this->director,
			['.storage'],
			null,
			true
		);
		if ($result->exitcode === 0) {
			if (is_object($storage) && in_array($storage->name, $result->output)) {
				$result = $this->getModule('status_sd')->getStatus(
					$this->director,
					$storage->name,
					StatusStorage::OUTPUT_TYPE_RUNNING
				);
				if ($result['error'] === 0) {
					$cb = function($job) {
						return $job['jobid'];
					};
					$jobids = array_map($cb, $result['output']);
					$result = (object)[
						'output' => [],
						'exitcode' => StorageError::ERROR_NO_ERRORS
					];
					if (count($jobids) > 0) {
						$result = $this->getModule('bconsole')->bconsoleCommand(
							$this->director,
							[
								'cancel',
								'jobid="' . implode(',', $jobids) . '"'
							]
						);
					}
					$this->output = $result->output;
					$this->error =  $result->exitcode;
				} else {
					$this->output = $result['output'];
					$this->error =  $result['error'];
				}
			} else {
				$this->output = StorageError::MSG_ERROR_STORAGE_DOES_NOT_EXISTS;
				$this->error = StorageError::ERROR_STORAGE_DOES_NOT_EXISTS;
			}
		} else {
			$this->output = $result->output;
			$this->error = $result->exitcode;
		}
	}
}
